package com.introtoandroid.samples.resourceroundup;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import org.xmlpull.v1.XmlPullParserException;

import android.app.Activity;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.NinePatchDrawable;
import android.os.Bundle;
import android.support.v4.content.ContextCompat;
import android.text.Html;
import android.text.TextUtils;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;

public class ResourceRoundupActivity extends Activity {

    /** Called when the activity is first created. */
    private static final String DEBUG_TAG= "ResourceRoundup Log";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_resource_roundup);

        // PRZYKŁADY PROSTYCH OPERACJI NA ZASOBACH (łańcuch znaków, wytłuszczony łańcuch znaków, wymiary i proste elementy graficzne).
        String myResourceString = getResources().getString(R.string.hello);
        CharSequence myResourceStringRich = getResources().getText(R.string.boldhello);
        int myResourceColor = ContextCompat.getColor(this, R.color.prettyTextColor);
        float myResourceDimension = getResources().getDimension(R.dimen.textPointSize);
        ColorDrawable myResourceDrawable = (ColorDrawable) ContextCompat.getDrawable(this, R.drawable.redDrawable);

        Log.d(DEBUG_TAG, "Wartość myResourceString wynosi: " + myResourceString);
        Log.d(DEBUG_TAG, "Wartość myResourceStringRich wynosi: " + myResourceStringRich.toString());
        Log.d(DEBUG_TAG, "Wartość myResourceColor wynosi: " + myResourceColor);
        Log.d(DEBUG_TAG, "Wartość myResourceDimension wynosi: " + myResourceDimension);
        if (myResourceDrawable != null) {
            Log.d(DEBUG_TAG, "Wartość myResourceDrawable wynosi: " + myResourceDrawable.toString()); // Niezbyt to ekscytujące, wiem...
        }

        // OBSŁUGA TABLICY ŁAŃCUCHÓW ZNAKÓW
        String[] aFlavors = getResources().getStringArray(R.array.flavors);
        for(int i=0; i<aFlavors.length; i++) {
            Log.d(DEBUG_TAG, "Wartość aFlavors["+ i + "] wynosi: "+ aFlavors[i]);
        }

        // OBSŁUGA ŁAŃCUCHA ZNAKÓW ZE SYMBOLAMI FORMATUJĄCYMI
        // Można użyć metody htmlEncode, by upewnić się, że łańcuch został odpowiednio zapisany. 
        // Oczywiście "Wygrałeś" wygląda nieźle bez żadnych dodatkowych zabiegów, jednak w innych
        // przypadkach użycie metody htmlEncode może się przydać...
        String escapedWin = TextUtils.htmlEncode("Wygrałeś");
        Log.d(DEBUG_TAG, "Wartość escapedWin: " + escapedWin);

        // Najpierw prosty przykład formatowania
        String mySimpleWinString = getResources().getString(R.string.winLose);
        Log.d(DEBUG_TAG, "Wartość mySimpleWinString: " + mySimpleWinString);
        String resultsText1 = String.format(mySimpleWinString, 5, 5, escapedWin);
        Log.d(DEBUG_TAG, "Wartość resultsText1 (simple): " + resultsText1);

        // Przykład z wykorzystaniem stylów
        String resultsTextFormat = getResources().getString(R.string.winLoseStyled);
        Log.d(DEBUG_TAG, "Wartość resultsTextFormat: " + resultsTextFormat);
        String resultsText = String.format(resultsTextFormat, 5, 5, escapedWin);
        Log.d(DEBUG_TAG, "Wartość resultsText: " + resultsText);
        CharSequence styledResults = Html.fromHtml(resultsText);
        Log.d(DEBUG_TAG, "Wartość styledResults: " + styledResults);

        // OBSŁUGA WIDŻETÓW, WIDOKÓW, OBRAZÓW
        // Pobieramy kontrolkę ImageViewi i wyświetlamy flagę w głównym układzie.
        ImageView flagImageView = (ImageView)findViewById(R.id.ImageView01);
        flagImageView.setImageResource(R.drawable.flag);

        // Pobieramy grafikę flagi, a następnie wybrane informacje na jej temat.
        BitmapDrawable bitmapFlag = (BitmapDrawable) ContextCompat.getDrawable(this, R.drawable.flag);
        if (bitmapFlag != null) {
            Log.d(DEBUG_TAG, "Grafika bitmapFlag ma wysokość: " + bitmapFlag.getIntrinsicHeight() + " i szerokość: " + bitmapFlag.getIntrinsicWidth());
        }

        // Grab a Nine-patch graphic and check out some stuff about it
        // Pobieramy grafikę typu Nine-patch, a następnie wybrane informacje na jej temat.
        NinePatchDrawable stretchy = (NinePatchDrawable) ContextCompat.getDrawable(this, R.drawable.pyramid);
        if (stretchy != null) {
            Log.d(DEBUG_TAG, "Grafika stretchy ma wysokość: " + stretchy.getIntrinsicHeight() + " i szerokość: " + stretchy.getIntrinsicWidth());
        }

        // OBSŁUGA ANIMACJI 
        // Kręcimy flagą (png) używając aminacji zdefiniowanej w pliku zasobów spin.xml.
        Animation an =  AnimationUtils.loadAnimation(this, R.anim.spin);
        flagImageView.startAnimation(an);

        // Włączamy pulsowanie czerwonego owalu, używając w tym celu zasobu animacji zdefiniowanej 
        // w pliku pulse.xml.
        ImageView redOval = (ImageView)findViewById(R.id.ImageView02);
        Animation an2 =  AnimationUtils.loadAnimation(this, R.anim.pulse);
        redOval.startAnimation(an2);

        // OBSŁUGA KOD XML
        XmlResourceParser myPets = getResources().getXml(R.xml.my_pets);

        try {
            inspectPetsXml(myPets);
        } catch (Exception e) {
            Log.e(DEBUG_TAG, "Wywołanie metody inspectPetsXml zakończyło się niepowodzeniem.", e);
        }

        // PRZYKŁAD OBSŁUGI NIEPRZETWORZONYCH PLIKÓW
        InputStream iFile = getResources().openRawResource(R.raw.limerick);
        try {
            String strFile = inputStreamToString(iFile);
            Log.d(DEBUG_TAG, "Oto limeryk ze strumienia wejściowego:\n"+ strFile);

        } catch (Exception e) {
            Log.e(DEBUG_TAG, "Wywołanie metody inputStreamToString zakończyło się niepowodzeniem.", e);
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.speed, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        if (id == R.string.action_settings) {
            return true;
        }

        return super.onOptionsItemSelected(item);
    }

    // Metoda analizuje plik XML i wyświetla wszystkie elementy pet oraz ich atrybuty.
    public static void inspectPetsXml(XmlResourceParser myPets) throws XmlPullParserException, IOException    {
        // Let's inspect my pets a little
        int eventType = -1;
        while (eventType != XmlResourceParser.END_DOCUMENT) {
            if(eventType == XmlResourceParser.START_DOCUMENT) {
                Log.d(DEBUG_TAG, "Document Start");
            } else if(eventType == XmlResourceParser.START_TAG) {

                // Pobieramy nazwę elementu (pets czy pet)
                String strName = myPets.getName();

                if(strName.equals("pet"))
                {
                    Log.d(DEBUG_TAG, "Znaleziono element PET");
                    Log.d(DEBUG_TAG, "Imię: "+myPets.getAttributeValue(null, "name"));
                    Log.d(DEBUG_TAG, "Gatunek: "+myPets.getAttributeValue(null, "type"));
                }
            }
            eventType = myPets.next();
        }

        Log.d(DEBUG_TAG, "Koniec dokumentu");
    }

    // Metoda konwertuje strumień wejściowy na łańcuch znaków i wyświetla go w dzienniku logcat.
    public String inputStreamToString(InputStream is) throws IOException    {
        StringBuffer sBuffer = new StringBuffer();
        BufferedReader dataIO = new BufferedReader( new InputStreamReader(is));
        String strLine;

        while((strLine=dataIO.readLine()) != null){
            sBuffer.append(strLine);
            sBuffer.append("\n");
        }

        dataIO.close();
        is.close();

        return sBuffer.toString();
    }
}
